-- GCI v.5.18® 2025© for LOCK-ON GREECE by =GR= Astr0 via Gemini AI

-- I. ΒΑΣΙΚΕΣ ΠΑΡΑΜΕΤΡΟΙ
local GCI_Vars = {
    scan_interval = 15,          
    display_duration = 15,       
    max_contacts = 2,            
    include_helos = false,       
    use_bullseye = false,        
    gci_enabled = true,          
    show_support = false,        
    show_headers = true,
    ultra_fast_view = false,     
    meters_per_nm = 1852,
    feet_per_meter = 3.28084,
    los_samples = 10,
    report_pos = {x = 0.9, y = 0.1}
}

-- II. ΠΙΝΑΚΕΣ ΑΙΣΘΗΤΗΡΩΝ
local sensorMaximumRanges = {
    ["a-50"] = 350, ["e-3a"] = 320, ["e-2c"] = 200, ["kj-2000"] = 350, ["55g6 ewr"] = 215, 
    ["1l13 ewr"] = 160, ["ewr p-37 bar lock"] = 180, ["fps-117 dome"] = 250, ["fps-117"] = 250, 
    ["p-19 s-125 sr"] = 140, ["p-10 s125 sr"] = 80, ["dog ear radar"] = 20, ["kub 1s91 str"] = 50, 
    ["s-300ps 64h6e sr"] = 180, ["patriot str"] = 150, ["hawk sr"] = 70, ["tor 9a331"] = 25, 
    ["osa 9a33 ln"] = 30, ["stennis"] = 96, ["kuznecow"] = 96, ["vinson"] = 96, ["cvn_75"] = 96, 
    ["TICONDEROG"] = 80, ["PIOTR"] = 135, ["default"] = 25
}

local airborneSensorTypes = { ["a-50"] = true, ["e-3a"] = true, ["e-2c"] = true, ["kj-2000"] = true }
local menuAddedGroups = {}

-- III. ΣΤΑΘΕΡΕΣ ΣΤΟΙΧΙΣΗΣ
local W_STATIC = { W_TYPE = 20, W_BULL_REF = 12, W_BRG = 5, W_DIST = 6, W_ALT = 7, W_ASPECT = 8 }
local S_STATIC = { S_TYPE_NEXT = "    ", S_DIST_ALT = "   ", S_BRG_DIST = "  ", S_ALT_ASP = "     " }

-- IV. ΒΟΗΘΗΤΙΚΕΣ ΣΥΝΑΡΤΗΣΕΙΣ
local function getDistance(p1, p2) return math.sqrt((p1.x - p2.x)^2 + (p1.z - p2.z)^2) end
local function getBearing(p1, p2)
    local angle = math.deg(math.atan2(p2.z - p1.z, p2.x - p1.x))
    return (angle < 0) and (angle + 360) or angle
end

local function formatFLorFeet(alt_m, ultra)
    local alt_ft = alt_m * GCI_Vars.feet_per_meter
    if ultra then
        return (alt_ft >= 10000) and string.format("FL%03d", math.floor(alt_ft/100)) or string.format("%d", math.floor(alt_ft))
    else
        local s = (alt_ft >= 10000) and string.format("FL%03d", math.floor(alt_ft/100)) or string.format("%dFT", math.floor(alt_ft/100)*100)
        return (string.len(s) < 6) and "   "..s or s
    end
end

local function checkLOS(sensor, target)
    local sPos, tPos = sensor:getPoint(), target:getPoint()
    local step = 1 / GCI_Vars.los_samples
    for i = 1, GCI_Vars.los_samples - 1 do
        local f = i * step
        if land.getHeight({x = sPos.x + (tPos.x - sPos.x) * f, y = sPos.z + (tPos.z - sPos.z) * f}) > (sPos.y + (tPos.y - sPos.y) * f) + 0.5 then return false end
    end
    return true
end

local function determineAspect(playerUnit, targetUnit)
    local pPos, tPos, tData = playerUnit:getPoint(), targetUnit:getPoint(), targetUnit:getPosition()
    if not tData or not tData.x then return "N/A" end
    local brgPlayer = getBearing(tPos, pPos)
    local tHeading = math.deg(math.atan2(tData.x.z, tData.x.x))
    if tHeading < 0 then tHeading = tHeading + 360 end
    local rel = math.abs(brgPlayer - tHeading)
    if rel > 180 then rel = 360 - rel end
    if rel < 45 then return "HOT" elseif rel > 135 then return "COLD" else return "FLANKING" end
end

-- V. ΚΥΡΙΑ ΛΟΓΙΚΗ
local function executeGCIv518()
    if not GCI_Vars.gci_enabled then return timer.getTime() + GCI_Vars.scan_interval end

    for _, side in pairs({1, 2}) do
        local players = coalition.getPlayers(side)
        local friendlySensors = {}
        local awacsActive = false
        
        for _, cat in ipairs({Group.Category.AIRPLANE, Group.Category.GROUND, Group.Category.SHIP}) do
            for _, g in ipairs(coalition.getGroups(side, cat)) do
                for _, u in ipairs(g:getUnits()) do
                    if u:isActive() and u:getLife() > 1 then
                        local type = u:getTypeName():lower()
                        if sensorMaximumRanges[type] then
                            table.insert(friendlySensors, u)
                            if airborneSensorTypes[type] then awacsActive = true end
                        end
                    end
                end
            end
        end

        for _, pUnit in ipairs(players) do
            if pUnit and pUnit:isActive() then
                local pGroup = pUnit:getGroup()
                local enemySide = (side == 1) and 2 or 1
                local detected = {}
                local seen = {}

                if GCI_Vars.show_support then
                    local groups = coalition.getGroups(side, Group.Category.AIRPLANE)
                    for _, g in ipairs(groups) do
                        for _, u in ipairs(g:getUnits()) do
                            if u:isActive() and u:getLife() > 1 and u ~= pUnit then
                                local tType = u:getTypeName():lower()
                                if airborneSensorTypes[tType] or u:getDesc().attributes["Tankers"] then
                                    table.insert(detected, {unit = u, dist = getDistance(pUnit:getPoint(), u:getPoint()), isFriendly = true})
                                end
                            end
                        end
                    end
                else
                    if #friendlySensors > 0 then
                        local enemyCats = {Group.Category.AIRPLANE}
                        if GCI_Vars.include_helos then table.insert(enemyCats, Group.Category.HELICOPTER) end
                        for _, sensor in ipairs(friendlySensors) do
                            local sRange = (sensorMaximumRanges[sensor:getTypeName():lower()] or 25) * GCI_Vars.meters_per_nm
                            for _, cat in ipairs(enemyCats) do
                                for _, eg in ipairs(coalition.getGroups(enemySide, cat)) do
                                    for _, t in ipairs(eg:getUnits()) do
                                        if t:isActive() and t:getLife() > 1 and not seen[t:getName()] then
                                            if getDistance(sensor:getPoint(), t:getPoint()) <= sRange then
                                                if airborneSensorTypes[sensor:getTypeName():lower()] or checkLOS(sensor, t) then
                                                    seen[t:getName()] = true
                                                    table.insert(detected, {unit = t, dist = getDistance(pUnit:getPoint(), t:getPoint()), isFriendly = false})
                                                end
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end

                table.sort(detected, function(a,b) return a.dist < b.dist end)
                
                local hText = GCI_Vars.include_helos and " [+HELO]" or ""
                local modeStr = GCI_Vars.use_bullseye and "BULLSEYE" or "BRAA"
                local viewMode = GCI_Vars.ultra_fast_view and "ULTRA-FAST VIEW" or "NORMAL VIEW"
                
                local header = string.format("GCI REPORT: %s  |  %s%s\nFORMAT: %s | INTERVAL: %d SEC | MAX CONTACTS: %d\n\n", 
                    (GCI_Vars.show_support) and "SUPPORT" or "ENEMY CONTACTS", viewMode, hText, modeStr, GCI_Vars.scan_interval, GCI_Vars.max_contacts)
                
                if GCI_Vars.show_headers then
                    if GCI_Vars.ultra_fast_view then
                        header = header .. "--------------------------------------------------\nBRG / DST      ALT      TYPE      ASPECT\n--------------------------------------------------\n"
                    else
                        header = header .. (GCI_Vars.use_bullseye and "                 TYPE   BRG  / DIST       ALT         ASPECT" or "                TYPE    BRG   DIST        ALT         ASPECT") .. "\n"
                    end
                end

                local body = ""
                if #detected == 0 then
                    if GCI_Vars.show_support then body = "NO FRIENDLY SUPPORT DETECTED"
                    elseif #friendlySensors == 0 then body = "NO FRIENDLY RADAR COVERAGE"
                    else body = "NO HOSTILE CONTACTS" end
                else
                    for i=1, math.min(#detected, GCI_Vars.max_contacts) do
                        local d = detected[i]
                        local t = d.unit
                        local tPos = t:getPoint()
                        local brg, dst, rawDist
                        rawDist = d.dist / GCI_Vars.meters_per_nm
                        
                        if GCI_Vars.use_bullseye then
                            local bull = coalition.getMainRefPoint(side)
                            brg = getBearing(bull, tPos)
                            dst = getDistance(bull, tPos) / GCI_Vars.meters_per_nm
                        else
                            brg = getBearing(pUnit:getPoint(), tPos)
                            dst = rawDist
                        end
                        
                        local typeLabel = string.upper(string.sub(t:getTypeName(),1,5))
                        if not d.isFriendly and not awacsActive then typeLabel = "BANDIT" end
                        local asp = determineAspect(pUnit, t)
                        local altStr = formatFLorFeet(tPos.y, GCI_Vars.ultra_fast_view)

                        local danger = ""
                        if not d.isFriendly and rawDist < 10 and asp == "HOT" then
                            danger = " <!>"
                        end

                        if GCI_Vars.ultra_fast_view then
                            -- Αφαίρεση του #%d μπροστά από την αναφορά
                            body = body .. string.format("%03d°/%02dNM | %-6s | %-6s | %-8s%s\n", brg, dst, altStr, typeLabel, asp, danger)
                        else
                            local line = ""
                            if GCI_Vars.use_bullseye then
                                line = string.format("%"..W_STATIC.W_TYPE.."s%s%"..W_STATIC.W_BULL_REF.."s%s%s%s%s", typeLabel, S_STATIC.S_TYPE_NEXT, string.format("%03.0f° / %03dNM", brg, dst), S_STATIC.S_DIST_ALT, altStr, S_STATIC.S_ALT_ASP, asp)
                            else
                                line = string.format("%"..W_STATIC.W_TYPE.."s%s%03.0f°%s%03dNM%s%s%s%s", typeLabel, S_STATIC.S_TYPE_NEXT, brg, S_STATIC.S_BRG_DIST, dst, S_STATIC.S_DIST_ALT, altStr, S_STATIC.S_ALT_ASP, asp)
                            end
                            body = body .. line .. danger .. "\n"
                        end
                    end
                end
                trigger.action.outTextForGroup(pGroup:getID(), header..body, GCI_Vars.display_duration, false, GCI_Vars.report_pos.x, GCI_Vars.report_pos.y)
            end
        end
    end
    return timer.getTime() + GCI_Vars.scan_interval
end

-- VI. RADIO MENU
local function BuildMenu(group)
    local gID = group:getID()
    if menuAddedGroups[gID] then return end
    local root = missionCommands.addSubMenuForGroup(gID, "GCI")
    local set = missionCommands.addSubMenuForGroup(gID, "SETTINGS", root)
    
    local mMax = missionCommands.addSubMenuForGroup(gID, "MAX CONTACTS", set)
    missionCommands.addCommandForGroup(gID, "2 CONTACTS", mMax, function() GCI_Vars.max_contacts = 2 end)
    missionCommands.addCommandForGroup(gID, "4 CONTACTS", mMax, function() GCI_Vars.max_contacts = 4 end)
    missionCommands.addCommandForGroup(gID, "6 CONTACTS", mMax, function() GCI_Vars.max_contacts = 6 end)

    local mInt = missionCommands.addSubMenuForGroup(gID, "SCAN INTERVAL", set)
    missionCommands.addCommandForGroup(gID, "15 SECONDS", mInt, function() GCI_Vars.scan_interval = 15 end)
    missionCommands.addCommandForGroup(gID, "30 SECONDS", mInt, function() GCI_Vars.scan_interval = 30 end)
    missionCommands.addCommandForGroup(gID, "60 SECONDS", mInt, function() GCI_Vars.scan_interval = 60 end)

    missionCommands.addCommandForGroup(gID, "FORMAT (BRAA/BULLSEYE)", set, function() GCI_Vars.use_bullseye = not GCI_Vars.use_bullseye end)
    missionCommands.addCommandForGroup(gID, "HELICOPTERS ON/OFF", set, function() GCI_Vars.include_helos = not GCI_Vars.include_helos end)
    missionCommands.addCommandForGroup(gID, "FRIENDLY SUPPORT ON/OFF", set, function() GCI_Vars.show_support = not GCI_Vars.show_support end)
    missionCommands.addCommandForGroup(gID, "HEADER VIEW ON/OFF", set, function() GCI_Vars.show_headers = not GCI_Vars.show_headers end)

    local ctrl = missionCommands.addSubMenuForGroup(gID, "CONTROL", root)
    missionCommands.addCommandForGroup(gID, "GCI SERVICE ON/OFF", ctrl, function() GCI_Vars.gci_enabled = not GCI_Vars.gci_enabled end)
    missionCommands.addCommandForGroup(gID, "ULTRA-FAST VIEW ON/OFF", ctrl, function() GCI_Vars.ultra_fast_view = not GCI_Vars.ultra_fast_view end)
    missionCommands.addCommandForGroup(gID, "RESET ALL", ctrl, function() 
        GCI_Vars.scan_interval = 15; GCI_Vars.max_contacts = 2; GCI_Vars.include_helos = false; GCI_Vars.use_bullseye = false; GCI_Vars.show_headers = true; GCI_Vars.show_support = false; GCI_Vars.gci_enabled = true; GCI_Vars.ultra_fast_view = false
    end)
    menuAddedGroups[gID] = true
end

-- VII. STARTUP
local function maintenance()
    for _, side in ipairs({1, 2}) do
        for _, u in ipairs(coalition.getPlayers(side)) do if u:getGroup() then BuildMenu(u:getGroup()) end end
    end
    return timer.getTime() + 10
end

timer.scheduleFunction(maintenance, nil, timer.getTime() + 1)
timer.scheduleFunction(executeGCIv518, nil, timer.getTime() + 5)
trigger.action.outText("GCI v.5.18® 2025© . . . Loaded successfully.", 10)